<?php
/************************************************************************
 * This file is part of EspoCRM.
 *
 * EspoCRM - Open Source CRM application.
 * Copyright (C) 2014-2023 Yurii Kuznietsov, Taras Machyshyn, Oleksii Avramenko
 * Website: https://www.espocrm.com
 *
 * EspoCRM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EspoCRM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with EspoCRM. If not, see http://www.gnu.org/licenses/.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "EspoCRM" word.
 ************************************************************************/

namespace Espo\Core\Utils\Database\Orm\LinkConverters;

use Espo\Core\Utils\Database\Orm\Defs\AttributeDefs;
use Espo\Core\Utils\Database\Orm\Defs\EntityDefs;
use Espo\Core\Utils\Database\Orm\Defs\RelationDefs;
use Espo\Core\Utils\Database\Orm\LinkConverter;
use Espo\Core\Utils\Log;
use Espo\ORM\Defs\RelationDefs as LinkDefs;
use Espo\ORM\Type\AttributeType;
use Espo\ORM\Type\RelationType;

class HasMany implements LinkConverter
{
    public function __construct(private Log $log) {}

    public function convert(LinkDefs $linkDefs, string $entityType): EntityDefs
    {
        if (!$linkDefs->hasForeignRelationName() && $linkDefs->getParam('disabled')) {
            // For bc.
            // @todo Remove in v9.0.
            return EntityDefs::create();
        }

        $name = $linkDefs->getName();
        $foreignEntityType = $linkDefs->getForeignEntityType();
        $foreignRelationName = $linkDefs->getForeignRelationName();
        $hasField = $linkDefs->getParam('hasField');

        $type = RelationType::HAS_MANY;

        /*$type = $linkDefs->hasRelationshipName() ?
            RelationType::MANY_MANY : // Revise.
            RelationType::HAS_MANY;*/

        if ($linkDefs->hasRelationshipName()) {
            $this->log->warning(
                "Issue with the link '{$name}' in '{$entityType}' entity type. Might be the foreign link " .
                "'{$foreignRelationName}' in '{$foreignEntityType}' entity type is missing. " .
                "Remove the problem link manually.");

            return EntityDefs::create();
        }

        return EntityDefs::create()
            ->withAttribute(
                AttributeDefs::create($name . 'Ids')
                    ->withType(AttributeType::JSON_ARRAY)
                    ->withNotStorable()
                    ->withParam('isLinkStub', !$hasField) // Revise. Change to notExportable?
            )
            ->withAttribute(
                AttributeDefs::create($name . 'Names')
                    ->withType(AttributeType::JSON_OBJECT)
                    ->withNotStorable()
                    ->withParam('isLinkStub', !$hasField)
            )
            ->withRelation(
                RelationDefs::create($name)
                    ->withType($type)
                    ->withForeignEntityType($foreignEntityType)
                    ->withForeignKey($foreignRelationName . 'Id')
                    ->withForeignRelationName($foreignRelationName)
            );
    }
}
